/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radial.data;

import mekanism.api.IDisableableEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.radial.IRadialDataHelper;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.common.lib.radial.data.BooleanRadialData;
import mekanism.common.lib.radial.data.DisableableEnumRadialData;
import mekanism.common.lib.radial.data.EnumRadialData;
import mekanism.common.lib.radial.data.TruncatedEnumRadialData;
import net.minecraft.resources.ResourceLocation;

@NothingNullByDefault
public class RadialDataHelper
implements IRadialDataHelper {
    public static final RadialDataHelper INSTANCE = new RadialDataHelper();

    private RadialDataHelper() {
    }

    @Override
    public <MODE extends Enum<MODE>> RadialData<MODE> dataForEnum(ResourceLocation identifier, MODE defaultMode) {
        if (defaultMode instanceof IDisableableEnum) {
            return new DisableableEnumRadialData<MODE>(identifier, defaultMode);
        }
        return new EnumRadialData<MODE>(identifier, defaultMode);
    }

    @Override
    public <MODE extends Enum<MODE>> RadialData<MODE> dataForEnum(ResourceLocation identifier, Class<MODE> enumClass) {
        if (IDisableableEnum.class.isAssignableFrom(enumClass)) {
            return new DisableableEnumRadialData<MODE>(identifier, enumClass);
        }
        return new EnumRadialData<MODE>(identifier, enumClass);
    }

    @Override
    public <MODE extends Enum<MODE>> RadialData<MODE> dataForTruncated(ResourceLocation identifier, int accessibleValues, MODE defaultMode) {
        return new TruncatedEnumRadialData<MODE>(identifier, accessibleValues, defaultMode);
    }

    @Override
    public RadialData<IRadialMode> booleanBasedData(ResourceLocation identifier, IRadialDataHelper.BooleanRadialModes modes, boolean defaultValue) {
        return new BooleanRadialData(identifier, modes, defaultValue);
    }
}

